/*
 * WidokMiniStrony.java
 *
 * Created on 25 maj 2004, 19:03
 */

package user;

import shared.*;
import javax.swing.*;
import java.awt.*;
import java.util.ArrayList;


import java.io.*;
    import javax.print.*;
    import javax.print.attribute.*;
    import javax.print.attribute.standard.*;
    import javax.print.event.*;
    
/** Wywietla dodatkowe informacje o firmie i jej logo.
 *
 * @author  ula
 */
public class WidokMiniStrony extends javax.swing.JPanel {
    
    /** Tworzy nowy obiekt klasy WidokMiniStrony. */
    public WidokMiniStrony() {
        initComponents();
        
        //wywalam drukowanie
        danePanel.remove(drukButton);
    }
    
    /** Tworzy nowy obiekt klasy WidokMiniStrony, wypeniajc odpowiednie pola danymi. 
     *
     *@param ogloszenie     ogoszenie, dla ktrego wywietlana jest mini strona
     *@param telefony       lista telefonw do danego ogoszenia
     */
    public WidokMiniStrony(Ogloszenie ogloszenie, ArrayList telefony) {
        initComponents();        
        
        //wywalam drukowanie
        danePanel.remove(drukButton);
        
        //daneTextArea.append("<html>");
        daneTextArea.append("Brana: " + ogloszenie.getBranza().getNazwa() + "\n");
        daneTextArea.append("\n");
        
        if (ogloszenie.getNazwa() != null)
            daneTextArea.append("Firma: " + ogloszenie.getNazwa() + "\n"); 
        else
            daneTextArea.append("Brak nazwy \n");
        
        daneTextArea.append("\n");
        if (ogloszenie.getNrMieszkania() == 0)
            daneTextArea.append("Adres: " + ogloszenie.getUlica().getNazwa() + " " + ogloszenie.getNrDomu() + "\n");
        else
            daneTextArea.append("Adres: " + ogloszenie.getUlica().getNazwa() + " " + ogloszenie.getNrDomu() +
                             " m. " + ogloszenie.getNrMieszkania() + "\n");
        
        daneTextArea.append("Data zaoenia: " + ogloszenie.getDataZalozenia().toString() + "\n");
        try {
            daneTextArea.append("NIP: " + Nip.intToNip(ogloszenie.getNip(), ogloszenie.isOsobowoscPrawna()) + "\n");
        } catch (Exception e) {
        }    
        if (ogloszenie.getStronaInternetowa() != null)
            daneTextArea.append("Strona internetowa: " + ogloszenie.getStronaInternetowa() + " \n");
            //daneTextArea.append("Strona internetowa: <a href=    "+ogloszenie.getStronaInternetowa()+">"+ogloszenie.getStronaInternetowa()+"</a> \n");
        else
            daneTextArea.append("Strona internetowa: - \n");
        if (ogloszenie.getEmail() != null)
            daneTextArea.append("E-mail: " + ogloszenie.getEmail() + "\n");
        else
            daneTextArea.append("E-mail: - \n");
        if (ogloszenie.getFax() != null)            
            daneTextArea.append("Fax: " + ogloszenie.getFax() + "\n");
        else
            daneTextArea.append("Fax: - \n");
        daneTextArea.append("Telefony:\n");
        for (int i = 0; i < telefony.size(); i++) {
            ArrayList tel = (ArrayList) telefony.get(i);
            daneTextArea.append((i+1) + ". " + (String)tel.get(0) + "   " + (String)tel.get(1) + "\n");
        }
        daneTextArea.append("\n");
        if (ogloszenie.getPlatne().getGodziny() != null)
            daneTextArea.append("Godziny otwarcia: " + ogloszenie.getPlatne().getGodziny() + "\n");
        daneTextArea.append("\n");
        if (ogloszenie.getPlatne().getUslugi() != null)
            daneTextArea.append("Usugi: " + ogloszenie.getPlatne().getUslugi() + "\n");
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        logoPanel = new javax.swing.JPanel();
        danePanel = new javax.swing.JPanel();
        daneTextArea = new javax.swing.JTextArea();
        drukButton = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        add(logoPanel, java.awt.BorderLayout.NORTH);

        danePanel.setLayout(new java.awt.BorderLayout());

        daneTextArea.setEditable(false);
        danePanel.add(daneTextArea, java.awt.BorderLayout.CENTER);

        drukButton.setText("Wersja do druku");
        drukButton.setToolTipText("Pokazuje wersj\u0119 strony bez logo.");
        drukButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                drukButtonActionPerformed(evt);
            }
        });

        danePanel.add(drukButton, java.awt.BorderLayout.SOUTH);

        add(danePanel, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    private void drukButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_drukButtonActionPerformed
        // Add your handling code here:
        //KonsolaUzytkownika.konsola.getAppletContext().
        JFrame frame = new JFrame("NIIKT- Mini strona ");
        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        
        Container c = frame.getContentPane();
        c.removeAll();
        c.setLayout(new BorderLayout());

        JEditorPane disp = new JEditorPane("text/html", "<html>mini<p>strona</html>");
        disp.setEditable(false);
        c.add(disp);
        
        c.validate();
        frame.setBounds(20, 20, 700, 500);
        frame.setVisible(true);
        
        
        //DocFlavor docf = DocFlavor.STRING.TEXT_HTML;
        
        try {
                // Open the image file
                //InputStream is = new BufferedInputStream(
                    //new FileInputStream("filename.gif"));
    
                Reader is = new StringReader("<html>mini<p>strona</html>");
                
                // Find the default service
                DocFlavor flavor = DocFlavor.STRING.TEXT_HTML;
                PrintService service = PrintServiceLookup.lookupDefaultPrintService();
    
                // Create the print job
                DocPrintJob job = service.createPrintJob();
                Doc doc = new SimpleDoc(is, flavor, null);
                //Doc doc = new SimpleDoc(
    
                // Monitor print job events; for the implementation of PrintJobWatcher,
                // see e702 Determining When a Print Job Has Finished
                //PrintJobWatcher pjDone = new PrintJobWatcher(job);
    
                // Print it
                job.print(doc, null);
    
                // Wait for the print job to be done
                //pjDone.waitForDone();
    
                // It is now safe to close the input stream
                is.close();
            } catch (PrintException e) {
                System.out.println("PRINT duuuuuuuuuuuuuuuuuuuuuuupa1");
            } catch (IOException e) {
                System.out.println("PRINT duuuuuuuuuuuuuuuuuuuuuuupa2");
            }
        
        
        /*
        System.out.println("DRUKOWANIE");
        javax.swing.JEditorPane disp = new javax.swing.JEditorPane("text/html", "<html>mini<p>strona</html>");
        disp.setEditable(false);
        disp.setVisible(true);
        System.out.println("DRUKOWANIE koniec");
         **/
    }//GEN-LAST:event_drukButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel danePanel;
    private javax.swing.JTextArea daneTextArea;
    private javax.swing.JButton drukButton;
    private javax.swing.JPanel logoPanel;
    // End of variables declaration//GEN-END:variables
    
}
