/*
 * WidokPodstawowy.java
 *
 * Created on 29 kwiecie 2004, 10:27
 */

package user;

import java.lang.*;
import javax.swing.*;
import java.awt.*;

import java.util.Calendar;
import java.util.GregorianCalendar;
import shared.*;

/** Widok podstawowy zawiera jako podwidoki widok zapyta i wynikw.
 *
 * @author  ula
 */
public class WidokPodstawowy extends javax.swing.JPanel {
    Dimension dP = new Dimension(660, 800);
    Dimension dZ = new Dimension(660, 125);
    Dimension dW = new Dimension(660, 600);
    boolean czyUlubione = true;
    
    /** Tworzy nowy obiekt klasy WidokPodstawowy. */
    public WidokPodstawowy() {
                
        initComponents();  
  
        ZapytaniePanel = new WidokZapytan();
        WynikiPanel = new WidokWynikow();

	setMinimumSize(dP);
	setPreferredSize(dP);
	setLayout(new java.awt.BorderLayout(1, 0));

	ZapytaniePanel.setMaximumSize(dZ);
	ZapytaniePanel.setMinimumSize(dZ);
	ZapytaniePanel.setPreferredSize(dZ);
	add(ZapytaniePanel, java.awt.BorderLayout.NORTH);

	WynikiPanel.setMaximumSize(dW);
	WynikiPanel.setMinimumSize(dW);
	WynikiPanel.setPreferredSize(dW);
	add(WynikiPanel, java.awt.BorderLayout.CENTER);
        
    }

    /** Ustawia dostpno guzika ulubionych w zalenoci, 
     * czy opcja ciasteczek w przegldarce jest wczona. 
     *
     *@param czy    true lub false, czy wczy guziki ulubionych
     */
    public void ustawGuzikUlubionych(boolean czy) {
        czyUlubione = czy;
    }
    
    /** Przekazuje podwidokom wyniki wyszukiwania do wywietlenia. 
     * @param fr        fragment mapy, na ktrym bd wywietlone wyniki, 
                        moe by null, jeli uytkownik nie chcia wynikw na mapie
     * @param wyniki    lista ogosze
     * @param telefony  lista telefonw dla tych ogosze
     */
    public void wyswietlWyniki(FragmentMapy fr, java.util.List wyniki, java.util.List telefony) {
        //1. elem listy to ew fragment mapki
        boolean czyMapka = false;
        
        
        remove(WynikiPanel);
        if (fr == null) {
            WynikiPanel = new WidokWynikow();
        } else {
            WynikiPanel = new WidokWynikowZMapa();
            czyMapka = true;
        }
        add(WynikiPanel, java.awt.BorderLayout.CENTER);
        WynikiPanel.setMaximumSize(dW);
        WynikiPanel.setMinimumSize(dW);
        WynikiPanel.setPreferredSize(dW);
        ((WidokWynikow)WynikiPanel).ustawGuzikUlubionych(czyUlubione);
        
        if (czyMapka == false)
            ((WidokWynikow)WynikiPanel).wyswietlWyniki(wyniki, telefony);
        else
            ((WidokWynikowZMapa)WynikiPanel).wyswietlWynikiMapa(fr, wyniki, telefony);
        
        //zaznacz w widoku zapytan klawisze porz i nast
        ((WidokZapytan)ZapytaniePanel).ustawNastPoprz(wyniki.size());
    }
    
    /** Przekazuje do widoku podstawowego komunikat do wywietlenia. 
     *
     *@param str    komunikat
     */
    public void wyswietlWyjatek(String str) {
        ((WidokWynikow)WynikiPanel).wyswietlWyjatek(str);
    }
    
    /** Odwiea oba widoki: zapyta i wynikw. */
    public void noweZapytanie() {
        ((WidokWynikow)WynikiPanel).odswiez();
        ((WidokWynikow)WynikiPanel).usunMapke();
        ((WidokZapytan)ZapytaniePanel).odswiez();
    }
    
    /** Ustawia w widoku zapyta podane kryteria wyszukiwania.
     *
     * @param kryteria  kryteria do ustawienia
     */
    public void ustawZapytanie(Kryteria kryteria) {
        ((WidokZapytan)ZapytaniePanel).ustawZapytanie(kryteria);
        ((WidokWynikow)WynikiPanel).odswiez();
    }
    
    /** Przekazuje widokowi wynikw identyfikator ogoszenia, ktre przestao
     * by ulubione i ktre naley zacz wywietla zwyczajnie.
     *
     *@param id     identyfikator ogoszenia, ktre przestao by ulubione
     */
    public void nieUlubione(Integer id) {
        ((WidokWynikow)WynikiPanel).nieUlubione(id);
    }
    
    /** Podwietla wybrany indeks na licie wynikw.
     *
     * @param nr    numer pozycji do podwietlenia
     */
    public void kliknietaMapka(int nr) {
        ((WidokWynikow)WynikiPanel).podswietl(nr);
    }
    
    /** Zaznacza na mapce lokalizacj ogoszenia o podanym indeksie z listy wynikw. 
     *
     *@param nr     numer pozycji na licie wynikw
     */
    public void kliknietaLista(int nr) {
        ((WidokWynikowZMapa)WynikiPanel).kliknietaLista(nr);
    }

    /** Przyjmuje i zapamituje odebrane z serwera warstwy mapy.
     *  @param warstwy odebrane warstwy mapy
     */
    public void odbierzWarstwy(WarstwaMapy[] warstwy) {
        ((WidokWynikow)WynikiPanel).odbierzWarstwy(warstwy);
    }
       
    /** Przyjmuje i zapamituje odebrane z serwera fragmenty mapy.
     *  @param fr odebrane fragmenty mapy
     */
    public void odbierzFragmenty(FragmentMapy[] fr) {
        ((WidokWynikow)WynikiPanel).odbierzFragmenty(fr);
    }
    
    /** Przyjmuje i zapamituje odebrane z serwera fragmenty ulicy.
     *  @param fr odebrane fragmenty ulicy
     */
    public void odbierzFragmentyUlicy(FragmentUlicy[] fr) {
        ((WidokWynikow)WynikiPanel).odbierzFragmentyUlicy(fr);
    }

    /** Przyjmuje i zapamituje odebrane z serwera ulice.
     *  @param ul odebrane ulice
     */
    public void odbierzUlice(java.util.List ul) {
        ((WidokWynikow)WynikiPanel).odbierzUlice(ul);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        ZapytaniePanel = new javax.swing.JPanel();
        WynikiPanel = new javax.swing.JPanel();

        setLayout(new java.awt.GridLayout(2, 1));

        ZapytaniePanel.setLayout(new java.awt.GridLayout(5, 1));

        add(ZapytaniePanel);

        WynikiPanel.setLayout(new java.awt.GridLayout(1, 2));

        add(WynikiPanel);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel WynikiPanel;
    private javax.swing.JPanel ZapytaniePanel;
    // End of variables declaration//GEN-END:variables
    
}
