/*
 * WidokUlubionych.java
 *
 * Created on 28 maj 2004, 18:31
 */

package user;

import user.opcjeUzytkownika.*;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;

/** Wywietlanie ulubionych ogosze w aplecie uytkownika.
 *
 * @author  ula
 */
public class WidokUlubionych extends javax.swing.JPanel implements ListSelectionListener {
    private ArrayList ulubione = new ArrayList();
    /** Model listy ulubionych ogosze. */
    public DefaultListModel modelListy = new DefaultListModel();
    
    /** Tworzy nowy obiekt klasy WidokUlubionych. */
    public WidokUlubionych() {
        initComponents();
        
        ulubioneList.addListSelectionListener(this);
        ulubioneList.setModel(modelListy);
        listScrollPane.getViewport().add(ulubioneList);
    }
    
    /** Wywietla ulubione ogoszenia w postaci posortowanej listy.
     *
     * @param lista     lista ulubionych ogosze
     */
    public void wyswietlUlubione(java.util.List lista) {
        ulubione.clear();
        ulubione.addAll(lista);
        modelListy.clear();
        if (lista.size() > 0) {           
            for(int i=0; i < lista.size(); i++) {
                modelListy.addElement(((UlubioneOgloszenie)lista.get(i)).wypisz());
            }
            ulubioneList.setSelectedIndex(0);
        }
    }
    
    public void valueChanged(ListSelectionEvent lse) {
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        guzikiPanel = new javax.swing.JPanel();
        usunButton = new javax.swing.JButton();
        powrotButton = new javax.swing.JButton();
        listScrollPane = new javax.swing.JScrollPane();
        ulubioneList = new javax.swing.JList();

        setLayout(new java.awt.BorderLayout());

        setBorder(new javax.swing.border.TitledBorder("Menu Ulubionych Og\u0142osze\u0144"));
        setFont(new java.awt.Font("Dialog", 1, 12));
        guzikiPanel.setLayout(new java.awt.GridLayout(1, 2));

        usunButton.setText("Usu\u0144");
        usunButton.setToolTipText("Usuwa og\u0142oszenie z ulubionych og\u0142osze\u0144.");
        usunButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                usunButtonActionPerformed(evt);
            }
        });

        guzikiPanel.add(usunButton);

        powrotButton.setText("Powr\u00f3t");
        powrotButton.setToolTipText("Wraca do poprzedniego widoku.");
        powrotButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                powrotButtonActionPerformed(evt);
            }
        });

        guzikiPanel.add(powrotButton);

        add(guzikiPanel, java.awt.BorderLayout.NORTH);

        listScrollPane.setViewportView(ulubioneList);

        add(listScrollPane, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    private void powrotButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_powrotButtonActionPerformed
        // Add your handling code here:
        KonsolaUzytkownika.konsola.pokazWidokPodstawowy();
    }//GEN-LAST:event_powrotButtonActionPerformed

    private void usunButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_usunButtonActionPerformed
        // Add your handling code here:
        int nr = ulubioneList.getSelectedIndex();
        
        KonsolaUzytkownika.konsola.usunZUlubionych((UlubioneOgloszenie)ulubione.get(nr));
        ulubione.remove(nr);
        //KonsolaUzytkownika.konsola.usunZUlubionych(nr);
        modelListy.remove(nr);
    }//GEN-LAST:event_usunButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel guzikiPanel;
    private javax.swing.JScrollPane listScrollPane;
    private javax.swing.JButton powrotButton;
    private javax.swing.JList ulubioneList;
    private javax.swing.JButton usunButton;
    // End of variables declaration//GEN-END:variables
    
}
