/*
 * WidokWynikow.java
 *
 * Created on 28 kwiecie 2004, 23:07
 */

package user;

import java.util.*;
import shared.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

/** Widok wywietlajcy wyniki wyszukiwania zadane przez uytkownika.
 *
 * @author  ula
 */

public class WidokWynikow extends javax.swing.JPanel  implements ItemListener { 
    /** Czy wyniki bd wywietlane wraz z map. */
    protected boolean czyMapka;    
    private boolean czyUlubione;
    private NawigacjaMapaLokalizacja mapkaLokalizacji = null;
    private ArrayList wyniki = new ArrayList();
    private ArrayList telefony = new ArrayList();

    /* Tworzy obiekt klasy WidokWynikow. */
    public WidokWynikow() {
        czyMapka = false;
        
        initComponents();
        
        wynikiList.addItemListener(this);
        
        lokalizacjaButton.setEnabled(true);
    }
    
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == ItemEvent.SELECTED) {
            int nr = ((Integer)e.getItem()).intValue();
        
            if (nr == -1)
                return;
        
            if (czyMapka)
                KonsolaUzytkownika.konsola.kliknietaLista(wynikiList.getSelectedIndex());
        
            if (((Ogloszenie)wyniki.get(nr)).getPlatne() == null)
                miniStronaButton.setEnabled(false);
            else
                miniStronaButton.setEnabled(true);
        
            wypiszInfo((Ogloszenie)wyniki.get(nr), (ArrayList)telefony.get(nr));
        }
    }    
   
    /** Ustawia dostpno guzika ulubionych w zalenoci, 
     * czy opcja ciasteczek w przegldarce jest wczona. 
     *
     *@param czy    true lub false, czy wczy guzik ulubionych
     */
    public void ustawGuzikUlubionych(boolean czy) {
        czyUlubione = czy;
        dodajUlubioneButton.setEnabled(czyUlubione);
    }    
    
    /** Odwiea ekran. */
    public void odswiez() {
        wynikiList.removeAll();
        telefony.clear();
        wyniki.clear();
        
        branzaLabel.setText("");
        ulubLabel.setText("");
        nazwaLabel.setText("");
        adresLabel.setText("");
        telLabel.setText("");
        faxLabel.setText("");
        mailLabel.setText("");
        wwwLabel.setText("");
    }

    /** Wypisuje dane ogoszenia w panelu informacyjnym. 
     *
     *@param ogl    dane ogoszenie
     *@param tel    lista jego telefonw
     */
    private void wypiszInfo(Ogloszenie ogl, ArrayList tel) {
        branzaLabel.setText("Brana:  "+ ogl.getBranza().getNazwa());
        
            if (czyUlubione && KonsolaUzytkownika.konsola.czyUlubione(ogl.getId()))
                ulubLabel.setText("            Ulubione ogoszenie");
            else
                ulubLabel.setText("");

        
        if (ogl.getNazwa() != null)
            nazwaLabel.setText("            "+ogl.getNazwa());
        else
            nazwaLabel.setText("");
        
        if (ogl.getNrMieszkania() != 0)
            adresLabel.setText("Adres:   "+ogl.getUlica().getNazwa()+" "+ogl.getNrDomu()+" m."+ogl.getNrMieszkania());
        else
            adresLabel.setText("Adres:   "+ogl.getUlica().getNazwa()+" "+ogl.getNrDomu());
        
        if (tel.size() > 0) {
            ArrayList t = (ArrayList)tel.get(0);
            if (t != null)
                telLabel.setText("Tel:       "+(String)t.get(0) +" "+(String)t.get(1));
            else
                telLabel.setText("Tel:       -");
        }
        if (ogl.getFax() != null)
            faxLabel.setText("Fax:       "+ogl.getFax());
        else
            faxLabel.setText("Fax:       -");
        
        if (ogl.getEmail() != null)
            mailLabel.setText("E-mail:  "+ogl.getEmail());
        else
            mailLabel.setText("E-mail:  -");
        
        if (ogl.getStronaInternetowa() != null)
            wwwLabel.setText("<html>WWW:    <a href=    "+ogl.getStronaInternetowa()+">"+ogl.getStronaInternetowa()+"</a></html>");
        else
            wwwLabel.setText("WWW:    -");
            
    }
    
    /** Wypisuje dane ogoszenia na licie wynikw. 
     *
     *@param ogl    dane ogoszenie
     *@param nr     numer porzdkowy na licie
     */
    private String wypiszLista(Ogloszenie ogl, int nr) {
        String str = null;
     
        if (czyUlubione && KonsolaUzytkownika.konsola.czyUlubione(ogl.getId()))
            str = (nr+1) + ".! "+ogl.getNazwa()+", ul."+ogl.getUlica().getNazwa()+" "+ogl.getNrDomu();
        else
            str = (nr+1) + ".  "+ogl.getNazwa()+", ul."+ogl.getUlica().getNazwa()+" "+ogl.getNrDomu();

        return str;
                
    }
    
    /** Wywietla wyniki wyszukiwania. 
     * @param listaWynikow    lista ogosze
     * @param listaTelefonow  lista telefonw dla tych ogosze
     */
    public void wyswietlWyniki(java.util.List listaWynikow, java.util.List listaTelefonow) {        
        wynikiList.removeAll();
        wyniki.clear();
        wyniki.addAll(listaWynikow);
        telefony.clear();
        telefony.addAll(listaTelefonow);
        if (wyniki.size() <= 0) 
            JOptionPane.showMessageDialog(null, "Nie znaleziono firmy o podanych parametrach");
        else {            
            for(int i=0; i < wyniki.size(); i++) {
                wynikiList.add(wypiszLista((Ogloszenie)wyniki.get(i), i));
            }
            wynikiList.select(0);
            wypiszInfo((Ogloszenie)wyniki.get(0), (ArrayList)telefony.get(0));
            
            if (((Ogloszenie)wyniki.get(0)).getPlatne() == null)
                miniStronaButton.setEnabled(false);
            else
                miniStronaButton.setEnabled(true);
        }
    }
    
    /** Wywietla na ekranie podany komunikat. 
     *
     *@param str    komunikat
     */
    public void wyswietlWyjatek(String str) {
        JOptionPane.showMessageDialog(null, str);
    }
    
    /** Podwietla wybrany indeks na licie wynikw.
     *
     * @param nr    numer pozycji do podwietlenia
     */
    public void podswietl(int nr) {
        wynikiList.select(nr);
        wypiszInfo((Ogloszenie)wyniki.get(nr), (ArrayList)telefony.get(nr));
    }
    
    /** Wywietla ogoszenie o podanym identyfikatorze jak zwyczajne ogoszenie. 
     *
     *@param id     identyfikator ogoszenia, ktre przestao by ulubione
     */
    public void nieUlubione(Integer id) {
        int nr = dajNr(id);
        if (nr == -1)
            return;
        //modelListy.remove(nr);
        //modelListy.add(nr, wypiszLista((Ogloszenie)wyniki.get(nr), nr));
        wynikiList.replaceItem(wypiszLista((Ogloszenie)wyniki.get(nr), nr), nr);
        wynikiList.select(nr);
        
        wypiszInfo((Ogloszenie)wyniki.get(nr), (ArrayList)telefony.get(nr));
    }
    
    /** Zwraca nr na licie wynikw ogoszenia o podanym identyfikatorze. */
    private int dajNr(Integer id) {
        for (int i=0; i<wyniki.size(); i++)
            if (((Ogloszenie)wyniki.get(i)).getId().equals(id))
                return i;
        return -1;
    }
    
    /** Usuwa z widoku mapk. */
    public void usunMapke() {
        if (mapkaLokalizacji != null) {
            mapkaLokalizacji = null;
            mapaPanel.removeAll();
        }
    }
    
    /** Przyjmuje i zapamituje odebrane z serwera warstwy mapy.
     *  @param warstwy odebrane warstwy mapy
     */
    public void odbierzWarstwy(WarstwaMapy[] warstwy) {
        if (mapkaLokalizacji != null)
            mapkaLokalizacji.odbierzWarstwy(warstwy);
    }
    
    /** Przyjmuje i zapamituje odebrane z serwera fragmenty mapy.
     *  @param fr odebrane fragmenty mapy
     */
    public void odbierzFragmenty(FragmentMapy[] fr) {
        if (mapkaLokalizacji != null)
            mapkaLokalizacji.odbierzFragmenty(fr);
    }
    
    /** Przyjmuje i zapamituje odebrane z serwera fragmenty ulicy.
     *  @param fr odebrane fragmenty ulicy
     */
    public void odbierzFragmentyUlicy(FragmentUlicy[] fr) {
        if (mapkaLokalizacji != null)
            mapkaLokalizacji.odbierzFragmentyUlicy(fr);
    }

    /** Przyjmuje i zapamituje odebrane z serwera ulice.
     *  @param ul odebrane ulice
     */
    public void odbierzUlice(java.util.List ul) {
        if (mapkaLokalizacji != null)
            mapkaLokalizacji.odbierzUlice(ul);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        zwyklePanel = new javax.swing.JPanel();
        wynikiPanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        wynikiList = new java.awt.List();
        jPanel2 = new javax.swing.JPanel();
        jPanel5 = new javax.swing.JPanel();
        jSeparator1 = new javax.swing.JSeparator();
        jPanel4 = new javax.swing.JPanel();
        infoPanel = new javax.swing.JPanel();
        branzaLabel = new javax.swing.JLabel();
        ulubLabel = new javax.swing.JLabel();
        nazwaLabel = new javax.swing.JLabel();
        pustyLabel2 = new javax.swing.JLabel();
        adresLabel = new javax.swing.JLabel();
        telLabel = new javax.swing.JLabel();
        faxLabel = new javax.swing.JLabel();
        mailLabel = new javax.swing.JLabel();
        wwwLabel = new javax.swing.JLabel();
        GuzikiPanel = new javax.swing.JPanel();
        dodajUlubioneButton = new javax.swing.JButton();
        wizytowkaButton = new javax.swing.JButton();
        miniStronaButton = new javax.swing.JButton();
        lokalizacjaButton = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        mapaPanel = new javax.swing.JPanel();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

        setBorder(new javax.swing.border.TitledBorder(null, "Wyniki", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 10)));
        zwyklePanel.setLayout(new javax.swing.BoxLayout(zwyklePanel, javax.swing.BoxLayout.X_AXIS));

        zwyklePanel.setMaximumSize(new java.awt.Dimension(2147483647, 225));
        zwyklePanel.setMinimumSize(new java.awt.Dimension(420, 225));
        zwyklePanel.setPreferredSize(new java.awt.Dimension(420, 225));
        wynikiPanel.setLayout(new java.awt.BorderLayout());

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.X_AXIS));

        jPanel1.add(wynikiList);

        wynikiPanel.add(jPanel1, java.awt.BorderLayout.CENTER);

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.X_AXIS));

        jPanel5.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 0, 0));

        jPanel5.setMinimumSize(new java.awt.Dimension(5, 0));
        jPanel5.setPreferredSize(new java.awt.Dimension(5, 0));
        jSeparator1.setOrientation(javax.swing.SwingConstants.VERTICAL);
        jSeparator1.setPreferredSize(new java.awt.Dimension(2, 225));
        jPanel5.add(jSeparator1);

        jPanel2.add(jPanel5);

        jPanel4.setLayout(new javax.swing.BoxLayout(jPanel4, javax.swing.BoxLayout.Y_AXIS));

        infoPanel.setLayout(new java.awt.GridLayout(9, 1));

        infoPanel.setMaximumSize(new java.awt.Dimension(260, 32767));
        infoPanel.setPreferredSize(new java.awt.Dimension(260, 0));
        branzaLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        infoPanel.add(branzaLabel);

        ulubLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        infoPanel.add(ulubLabel);

        infoPanel.add(nazwaLabel);

        infoPanel.add(pustyLabel2);

        adresLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        infoPanel.add(adresLabel);

        telLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        infoPanel.add(telLabel);

        faxLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        infoPanel.add(faxLabel);

        mailLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        infoPanel.add(mailLabel);

        wwwLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        wwwLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                wwwLabelMouseClicked(evt);
            }
        });

        infoPanel.add(wwwLabel);

        jPanel4.add(infoPanel);

        GuzikiPanel.setLayout(new java.awt.GridLayout(2, 4));

        GuzikiPanel.setMaximumSize(new java.awt.Dimension(32767, 20));
        GuzikiPanel.setMinimumSize(new java.awt.Dimension(0, 0));
        GuzikiPanel.setPreferredSize(new java.awt.Dimension(0, 40));
        dodajUlubioneButton.setFont(new java.awt.Font("Dialog", 0, 12));
        dodajUlubioneButton.setText("Ulubione");
        dodajUlubioneButton.setToolTipText("Dodaje do ulubionych lub uaktualnia og\u0142oszenie.");
        dodajUlubioneButton.setMaximumSize(new java.awt.Dimension(90, 20));
        dodajUlubioneButton.setMinimumSize(new java.awt.Dimension(90, 20));
        dodajUlubioneButton.setPreferredSize(new java.awt.Dimension(90, 20));
        dodajUlubioneButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dodajUlubioneButtonActionPerformed(evt);
            }
        });

        GuzikiPanel.add(dodajUlubioneButton);

        wizytowkaButton.setFont(new java.awt.Font("Dialog", 0, 12));
        wizytowkaButton.setText("Wizyt\u00f3wka");
        wizytowkaButton.setToolTipText("Zapami\u0119tuje wizyt\u00f3wk\u0119 w formacie vcf.");
        wizytowkaButton.setMaximumSize(new java.awt.Dimension(102, 20));
        wizytowkaButton.setMinimumSize(new java.awt.Dimension(102, 20));
        wizytowkaButton.setPreferredSize(new java.awt.Dimension(102, 20));
        wizytowkaButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wizytowkaButtonActionPerformed(evt);
            }
        });

        GuzikiPanel.add(wizytowkaButton);

        miniStronaButton.setFont(new java.awt.Font("Dialog", 0, 12));
        miniStronaButton.setText("Mini Strona");
        miniStronaButton.setToolTipText("Wy\u015bwietla dodatkowe informacje o firmie.");
        miniStronaButton.setMaximumSize(new java.awt.Dimension(105, 20));
        miniStronaButton.setMinimumSize(new java.awt.Dimension(105, 20));
        miniStronaButton.setPreferredSize(new java.awt.Dimension(105, 20));
        miniStronaButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                miniStronaButtonActionPerformed(evt);
            }
        });

        GuzikiPanel.add(miniStronaButton);

        lokalizacjaButton.setFont(new java.awt.Font("Dialog", 0, 12));
        lokalizacjaButton.setText("Lokalizacja");
        lokalizacjaButton.setToolTipText("Pokazuje lokalizacj\u0119 firmy na mapie.");
        lokalizacjaButton.setMaximumSize(new java.awt.Dimension(103, 20));
        lokalizacjaButton.setMinimumSize(new java.awt.Dimension(103, 20));
        lokalizacjaButton.setPreferredSize(new java.awt.Dimension(103, 20));
        lokalizacjaButton.setEnabled(false);
        lokalizacjaButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lokalizacjaButtonActionPerformed(evt);
            }
        });

        GuzikiPanel.add(lokalizacjaButton);

        jPanel4.add(GuzikiPanel);

        jPanel2.add(jPanel4);

        wynikiPanel.add(jPanel2, java.awt.BorderLayout.EAST);

        zwyklePanel.add(wynikiPanel);

        add(zwyklePanel);

        jPanel3.setMaximumSize(new java.awt.Dimension(32767, 10));
        add(jPanel3);

        add(mapaPanel);

    }//GEN-END:initComponents

    private void wwwLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_wwwLabelMouseClicked
        // Add your handling code here:
        int nr = wynikiList.getSelectedIndex();
        Ogloszenie ogl = (Ogloszenie) wyniki.get(nr);
        String adr = "http://" + ogl.getStronaInternetowa();
        try {
            KonsolaUzytkownika.konsola.getAppletContext().showDocument(new java.net.URL(adr), "_blank");
        } catch(Exception e) {
            e.printStackTrace();
        }
    }//GEN-LAST:event_wwwLabelMouseClicked

    private void lokalizacjaButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lokalizacjaButtonActionPerformed
        // Add your handling code here:
        //spr ktore ogloszenie pokazac na mapce
        if (wynikiList.getSelectedIndex() == -1) return;
        if (mapkaLokalizacji == null) {
            mapkaLokalizacji = new NawigacjaMapaLokalizacja();
            mapkaLokalizacji.initWidok(KonsolaUzytkownika.konsola.komSieciowa, KonsolaUzytkownika.konsola.getCodeBase().toString());
            mapaPanel.add(mapkaLokalizacji);
        }
        mapkaLokalizacji.pokazOgloszenie((Ogloszenie)wyniki.get(wynikiList.getSelectedIndex()));
//        int nr = wynikiList.getSelectedIndex();
//        KonsolaUzytkownika.konsola.kliknietaLista(nr);
    }//GEN-LAST:event_lokalizacjaButtonActionPerformed

    private void dodajUlubioneButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dodajUlubioneButtonActionPerformed
        // Add your handling code here:
        //spr ktore ogloszenie chcemy dodac do ulubionych
        //przeslij jego nr na liscie wynikow do konsoli
        int nr = wynikiList.getSelectedIndex();
        KonsolaUzytkownika.konsola.dodajDoUlubionych(nr);
        //wynikiList.setSelectedIndex(nr);
        //modelListy.remove(nr);
        //modelListy.add(nr, wypiszLista((Ogloszenie)wyniki.get(nr), nr));
        wynikiList.replaceItem(wypiszLista((Ogloszenie)wyniki.get(nr), nr), nr);
        //wynikiList.setSelectedIndex(nr);
        wynikiList.select(nr);
        wypiszInfo((Ogloszenie)wyniki.get(nr), (ArrayList)telefony.get(nr));

    }//GEN-LAST:event_dodajUlubioneButtonActionPerformed

    private void miniStronaButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_miniStronaButtonActionPerformed
        // Add your handling code here:
        //sprawdz jakie to ogloszenie jest wybrane na liscie
        //wyslij do konsoli informacje ze trzeba wyswietlic mini strone
        int nr = wynikiList.getSelectedIndex();
        KonsolaUzytkownika.konsola.pokazWidokMiniStrony(nr);
    }//GEN-LAST:event_miniStronaButtonActionPerformed

    private void wizytowkaButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wizytowkaButtonActionPerformed
        // Add your handling code here:
        //sprawdz jakie to ogloszenie jest wybrane na liscie
        //wyslij do konsoli informacje ze trzeba zapisac wizytowke
        int nr = wynikiList.getSelectedIndex();
        KonsolaUzytkownika.konsola.generujWizytowke(nr);
    }//GEN-LAST:event_wizytowkaButtonActionPerformed
   
   
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel GuzikiPanel;
    private javax.swing.JLabel adresLabel;
    private javax.swing.JLabel branzaLabel;
    private javax.swing.JButton dodajUlubioneButton;
    private javax.swing.JLabel faxLabel;
    private javax.swing.JPanel infoPanel;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JSeparator jSeparator1;
    protected javax.swing.JButton lokalizacjaButton;
    private javax.swing.JLabel mailLabel;
    protected javax.swing.JPanel mapaPanel;
    private javax.swing.JButton miniStronaButton;
    private javax.swing.JLabel nazwaLabel;
    private javax.swing.JLabel pustyLabel2;
    private javax.swing.JLabel telLabel;
    private javax.swing.JLabel ulubLabel;
    private javax.swing.JButton wizytowkaButton;
    private javax.swing.JLabel wwwLabel;
    private java.awt.List wynikiList;
    private javax.swing.JPanel wynikiPanel;
    private javax.swing.JPanel zwyklePanel;
    // End of variables declaration//GEN-END:variables
    
}
