/*
 * WidokWynikowZMapa.java
 *
 * Created on 17 czerwiec 2004, 21:27
 */

package user;

import shared.*;
import java.util.List;

/** Komponent odpowiedzialny za prezentacj wynikw wyszukiwania
 *  wraz z ich wizualizacj na mapce.
 *
 * @author  me201258
 */
public class WidokWynikowZMapa extends WidokWynikow {
    
    private NawigacjaMapaUser nawigacjaMapa;
    
    /** Tworzy nowy obiekt klasy WidokWynikowZMapa. */
    public WidokWynikowZMapa() {
        lokalizacjaButton.setEnabled(false);
    }
    
    /** Wyrnienie na mapce okrelonej firmy.
     *  @param nr indeks firmy do wyrnienia.
     */
    public void kliknietaLista(int nr) {
        nawigacjaMapa.wybranoFirme(nr);
    }
    
    public void odbierzWarstwy(WarstwaMapy[] warstwy) {
        nawigacjaMapa.odbierzWarstwy(warstwy);
    }
    
    public void odbierzFragmenty(FragmentMapy[] fr) {
        nawigacjaMapa.odbierzFragmenty(fr);
    }
    
    public void odbierzFragmentyUlicy(FragmentUlicy[] fr) {
        nawigacjaMapa.odbierzFragmentyUlicy(fr);
    }

    public void odbierzUlice(List ul) {
        nawigacjaMapa.odbierzUlice(ul);
    }
    
    public void usunMapke() {
        mapaPanel.removeAll();
        repaint();
    }

    /** Wywietla list wynikw wraz z ich prezentacj na mapce.
     *  @param fr wybrany przez serwer fragment mapy najwaciwszy do prezentacji wynikw
     *  @param wyniki lista wynikw
     *  @param telefony lista telefonw firm z wynikw
     */
    public void wyswietlWynikiMapa(FragmentMapy fr, List wyniki, List telefony) {
        //inicjalizujemy widok mapy
        czyMapka = true;
        nawigacjaMapa = new NawigacjaMapaUser();
        nawigacjaMapa.initWidok(KonsolaUzytkownika.konsola.komSieciowa, KonsolaUzytkownika.konsola.getCodeBase().toString(), fr, wyniki);
        mapaPanel.add(nawigacjaMapa);
        //inicjalizujemy standardowe wyniki
        wyswietlWyniki(wyniki, telefony);
        kliknietaLista(0);
    }
}
