/*
 * WidokZapytan.java
 *
 * Created on 9 kwiecie 2004, 22:00
 */

package user;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Date;
import shared.*;
import java.rmi.RemoteException;
import javax.swing.*;
import java.awt.*;

/** Widok wywietlajcy formularz do zadawania kryteriw wyszukiwania.
 *
 * @author  ula
 */
public class WidokZapytan extends javax.swing.JPanel 
    implements komponenty.BranzaWaiter {
        
     //katalog branz   
     shared.branze.KatalogBranzDrzewo kb = null;
        
    //kryteria zapytania
    Kryteria kryteria;
    int ile = 10;
    int zacznijOd = 0;
    String nazwa = null;
    String nip = null;
    String slowoKluczowe = null;
    String ulica = null;
    
    int promien = 200; //w m
    Integer rok = null;
    int kiedy = 1; //data i mlodsze
    boolean czyMapka = false;
    //czy w okolicy rozpoznajemy w kryteriach na podstawie nr domu
    //nr domu = null => wyszukiwanie na ulicy
    //wpp w okolicy wokol podanego numeru
    boolean czyWOkolicy = false;
    //jak w okolicy = true ale nr nie podany to default = 0
    Integer nr = null; 
    
    shared.Branza branza = null;  
    
    private String[] promienie = {"200m", "500m", "1km", "2km"};
    private int[] promienieInt = {200, 500, 1000, 2000};
    
    private String[] daty = {"modsze", "starsze", "dokadnie z"};
    
    /** Tworzy nowy obiekt WidokZapytan. */
    public WidokZapytan() {
        initComponents();
        for (int i=0; i < promienie.length; i++)
            PromienComboBox.addItem(promienie[i]);
        for (int i=0; i < daty.length; i++)
            DatyComboBox.addItem(daty[i]);
    }
    
    /** Odwiea widok zapyta. */
    public void odswiez() {
        //ile = 10;
        zacznijOd = 0;
        nazwa = null;
        nip = null;
        slowoKluczowe = null;
        ulica = null;
        nr = null;
        promien = 200; //w m
        rok = null;
        kiedy = 1; //data i mlodsze
        czyMapka = false;
        czyWOkolicy = false;
        branza = null;  
        
        NipTextField.setText("");
        NazwaTextField.setText("");
        SlowoKluczoweTextField.setText("");
        DataZalozeniaTextField.setText("");
        UlicaTextField.setText("");
        NumerTextField.setText("");
        BranzaTextLabel.setText("");
        
        wynikiNaMapceChceckbox.setSelected(false);
        czyWOkolicyCheckbox.setSelected(false);
        PromienComboBox.setSelectedIndex(0);
        PromienComboBox.setEnabled(false);
        
        KolejneButton.setEnabled(false);
        PoprzednieButton.setEnabled(false);
        
    }
    
    /** Ustawia podane kryteria wyszukiwania w polach widoku. 
     *
     *@param k      zadane kryteria
     */
    public void ustawZapytanie(Kryteria k) {
        odswiez();
        ile = k.getIle();
        zacznijOd = k.getZacznijOd();
        nazwa = k.getNazwa();
        nip = k.getNip();
        slowoKluczowe = k.getSlowoKluczowe();
        ulica = k.getUlica();
        nr = k.getNr();
        if (nr == null) //na ulicy
            czyWOkolicy = false;
        else //wokol zadanego nru
            czyWOkolicy = true;
        
        promien = k.getPromien();
        rok = k.getRokZalozenia();
        kiedy = k.getDataKiedy();
        czyMapka = k.getCzyMapka();
        
        branza = k.getBranza();
        
        if (nazwa != null)
            NazwaTextField.setText(nazwa);
        if (nip != null)
            NipTextField.setText(nip);
        if (slowoKluczowe != null)
            SlowoKluczoweTextField.setText(slowoKluczowe);
        if (ulica != null)
            UlicaTextField.setText(ulica);
        if (branza != null)
            BranzaTextLabel.setText(branza.getNazwa());
        
        wynikiNaMapceChceckbox.setSelected(czyMapka);
        
        czyWOkolicyCheckbox.setSelected(czyWOkolicy);
        
        switch (kiedy) {
            case -1: DatyComboBox.setSelectedIndex(1);//StarszeButton.setSelected(true);
            case  0: DatyComboBox.setSelectedIndex(2);//DokladnieButton.setSelected(true);
            case  1: DatyComboBox.setSelectedIndex(0);//MlodszeButton.setSelected(true);
        }
        
        if (rok != null)
            DataZalozeniaTextField.setText(rok.toString());
        
        if (nr != null)
            NumerTextField.setText(nr.toString());
        
        PromienComboBox.setSelectedItem(promienie[dajNrPromienia(promien)]);
        
        if (zacznijOd > 0)
            PoprzednieButton.setEnabled(true);
        
    }
    
    /** Odczytuje z formularza podane kryteria wyszukiwania.
     *
     *@param zacznij    pocztek interesujcego uytkownika fragmentu listy wynikw (wyniki przychodz w kawakach 10. elementowych
     * @return kryteria wyszukiwania, ktre zostan przesane do serwera
     */
    private Kryteria ustawKryteria(int zacznij) {
        //ile = 10;
        //zacznijOd = 0;
        zacznijOd = zacznij;
        nazwa = null;
        nip = null;
        slowoKluczowe = null;
        ulica = null;
        nr = null;
        promien = 200; //w m
        rok = null;
        kiedy = 1; //data i mlodsze
        czyMapka = false;
        czyWOkolicy = false;
        
        if (this.NipTextField.getText().length() > 0)
            nip = this.NipTextField.getText();
        
        if (this.NazwaTextField.getText().length() > 0)
            nazwa = this.NazwaTextField.getText();
        if (this.SlowoKluczoweTextField.getText().length() > 0)
            slowoKluczowe = this.SlowoKluczoweTextField.getText();
        
        if (this.DataZalozeniaTextField.getText().length() > 0) {
            try {
                rok = new Integer(this.DataZalozeniaTextField.getText());
            } catch (Exception e) {
                KonsolaUzytkownika.konsola.wyswietlWyjatek("Niepoprawny rok zaoenia. Pominity w wyszukiwaniu.");
                rok = null;
            }
        } else 
            rok = null;
        
        if (this.UlicaTextField.getText().length() > 0)
            ulica = this.UlicaTextField.getText();
        
        if (czyWOkolicyCheckbox.isSelected()) {
            //wokol pktu
            if (this.NumerTextField.getText().length() > 0) {
                //jesli pkt podany to wokol niego
                try {
                    nr = new Integer(this.NumerTextField.getText());
                } catch (Exception e) {
                    KonsolaUzytkownika.konsola.wyswietlWyjatek("Niepoprawny nr domu. Wyszukanie wok punktu wyznaczajcego rodek ulicy.");
                    nr = new Integer(0);
                }
                //wpp wokol srodka ulicy
              
            } else
                nr = new Integer(0);
        }  else
            //na ulicy
            nr = null;
        
        //branza zostala ustawiona podczas przegladania KB, ustawia sie sama
        
        promien = promienieInt[PromienComboBox.getSelectedIndex()];
        
        if (DatyComboBox.getSelectedIndex() == 1)//if (this.StarszeButton.isSelected())
            kiedy = -1;
        if (DatyComboBox.getSelectedIndex() == 2)//if (this.DokladnieButton.isSelected())
            kiedy = 0;
        if (DatyComboBox.getSelectedIndex() == 0)//if (this.MlodszeButton.isSelected())
            kiedy = 1;
        
        czyMapka = wynikiNaMapceChceckbox.isSelected();
        
        kryteria = new Kryteria(nip, nazwa, slowoKluczowe, rok, kiedy, ulica, nr, promien, branza, czyMapka, ile, zacznijOd);
        return kryteria;
    }
    
    /** Blokuje lub udostepnia klawisze pozwalajce wyszukiwa
     * kolejne lub poprzednie 10 wynikw w zalenoci od dlugoci wynikw. 
     *
     *@param dl     dugo wynikw, ktre ostatnio byy wywietlane
     */
    public void ustawNastPoprz(int dl) {
        //System.out.println("USTAW POPRZ dl=" + dl + "zacznijOd=" + zacznijOd);
        if (dl != 0 && (dl%ile) == 0)
            KolejneButton.setEnabled(true);
        else
            KolejneButton.setEnabled(false);
        
        //if (zacznijOd > 0 && dl != 0)
        if (zacznijOd >= ile+0 )
            PoprzednieButton.setEnabled(true);
        else
            PoprzednieButton.setEnabled(false);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        DataZalozeniaGroup = new javax.swing.ButtonGroup();
        MapkaGroup = new javax.swing.ButtonGroup();
        WOkolicyGroup = new javax.swing.ButtonGroup();
        StringPanel = new javax.swing.JPanel();
        NazwaLabel = new javax.swing.JLabel();
        NazwaTextField = new javax.swing.JTextField();
        SlowoKluczoweLabel = new javax.swing.JLabel();
        SlowoKluczoweTextField = new javax.swing.JTextField();
        DataPanel = new javax.swing.JPanel();
        DataZalozeniaLabel = new javax.swing.JLabel();
        DataZalozeniaTextField = new javax.swing.JTextField();
        DatyComboBox = new javax.swing.JComboBox();
        NipLabel = new javax.swing.JLabel();
        NipTextField = new javax.swing.JTextField();
        jSeparator4 = new javax.swing.JSeparator();
        GuzikiPanel = new javax.swing.JPanel();
        KolejneButton = new javax.swing.JButton();
        WyszukajButton = new javax.swing.JButton();
        PoprzednieButton = new javax.swing.JButton();
        WOkolicyPanel = new javax.swing.JPanel();
        UlicaLabel = new javax.swing.JLabel();
        UlicaTextField = new javax.swing.JTextField();
        NumerLabel = new javax.swing.JLabel();
        PromienComboBox = new javax.swing.JComboBox();
        czyWOkolicyCheckbox = new javax.swing.JCheckBox();
        NumerTextField = new javax.swing.JTextField();
        wynikiNaMapceChceckbox = new javax.swing.JCheckBox();
        BranzaPanel = new javax.swing.JPanel();
        BranzaLabel = new javax.swing.JLabel();
        BranzaTextLabel = new javax.swing.JLabel();
        przegladajBranzeButton = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();
        jSeparator2 = new javax.swing.JSeparator();
        jSeparator3 = new javax.swing.JSeparator();

        setLayout(null);

        setBorder(new javax.swing.border.TitledBorder(null, "Zapytanie", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 10)));
        setAutoscrolls(true);
        StringPanel.setLayout(null);

        NazwaLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        NazwaLabel.setText("Nazwa");
        StringPanel.add(NazwaLabel);
        NazwaLabel.setBounds(0, 0, 60, 15);

        NazwaTextField.setColumns(10);
        NazwaTextField.setToolTipText("Podaj nazw\u0119 firmy.");
        StringPanel.add(NazwaTextField);
        NazwaTextField.setBounds(91, 0, 170, 20);

        SlowoKluczoweLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        SlowoKluczoweLabel.setText("S\u0142owo kluczowe");
        StringPanel.add(SlowoKluczoweLabel);
        SlowoKluczoweLabel.setBounds(0, 20, 90, 15);

        SlowoKluczoweTextField.setColumns(10);
        SlowoKluczoweTextField.setToolTipText("Podaj s\u0142owo zwi\u0105zane z bran\u017c\u0105, kt\u00f3ra Ci\u0119 interesuje.");
        StringPanel.add(SlowoKluczoweTextField);
        SlowoKluczoweTextField.setBounds(91, 20, 170, 20);

        add(StringPanel);
        StringPanel.setBounds(10, 40, 260, 40);

        DataPanel.setLayout(null);

        DataZalozeniaLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        DataZalozeniaLabel.setText("Rok za\u0142o\u017cenia");
        DataPanel.add(DataZalozeniaLabel);
        DataZalozeniaLabel.setBounds(0, 0, 90, 15);

        DataZalozeniaTextField.setColumns(5);
        DataZalozeniaTextField.setToolTipText("Podaj rok za\u0142o\u017cenia firm.");
        DataPanel.add(DataZalozeniaTextField);
        DataZalozeniaTextField.setBounds(90, 0, 55, 18);

        DatyComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        DatyComboBox.setToolTipText("Wybierz spos\u00f3b wyszukiwania po roku za\u0142o\u017cenia.");
        DataPanel.add(DatyComboBox);
        DatyComboBox.setBounds(0, 20, 145, 20);

        NipLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        NipLabel.setText("NIP");
        DataPanel.add(NipLabel);
        NipLabel.setBounds(0, 42, 19, 15);

        NipTextField.setColumns(10);
        NipTextField.setToolTipText("Podaj NIP firmy, kt\u00f3ra Ci\u0119 interesuje.");
        DataPanel.add(NipTextField);
        NipTextField.setBounds(30, 42, 115, 20);

        DataPanel.add(jSeparator4);
        jSeparator4.setBounds(0, 40, 144, 2);

        add(DataPanel);
        DataPanel.setBounds(510, 20, 147, 62);

        GuzikiPanel.setLayout(null);

        GuzikiPanel.setMinimumSize(new java.awt.Dimension(640, 25));
        KolejneButton.setText("Kolejne 10");
        KolejneButton.setToolTipText("Nast\u0119pne 10 firm o podanych parametrach.");
        KolejneButton.setEnabled(false);
        KolejneButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                KolejneButtonActionPerformed(evt);
            }
        });

        GuzikiPanel.add(KolejneButton);
        KolejneButton.setBounds(500, 10, 145, 20);

        WyszukajButton.setBackground(new java.awt.Color(255, 204, 0));
        WyszukajButton.setFont(new java.awt.Font("Dialog", 1, 14));
        WyszukajButton.setText("Wyszukaj");
        WyszukajButton.setToolTipText("Wci\u015bnij, aby rozpocz\u0105\u0107 wyszukiwanie firm o podanych parametrach.");
        WyszukajButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                WyszukajButtonActionPerformed(evt);
            }
        });

        GuzikiPanel.add(WyszukajButton);
        WyszukajButton.setBounds(0, 0, 260, 30);

        PoprzednieButton.setText("Poprzednie 10");
        PoprzednieButton.setToolTipText("Poprzednie 10 firm z danego wyszukiwania.");
        PoprzednieButton.setEnabled(false);
        PoprzednieButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PoprzednieButtonActionPerformed(evt);
            }
        });

        GuzikiPanel.add(PoprzednieButton);
        PoprzednieButton.setBounds(347, 10, 145, 20);

        add(GuzikiPanel);
        GuzikiPanel.setBounds(10, 90, 645, 30);

        WOkolicyPanel.setLayout(null);

        UlicaLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        UlicaLabel.setText("Ulica");
        WOkolicyPanel.add(UlicaLabel);
        UlicaLabel.setBounds(0, 0, 30, 20);

        UlicaTextField.setColumns(10);
        UlicaTextField.setToolTipText("Podaj nazw\u0119 ulicy.");
        WOkolicyPanel.add(UlicaTextField);
        UlicaTextField.setBounds(30, 0, 140, 20);

        NumerLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        NumerLabel.setText("Nr");
        WOkolicyPanel.add(NumerLabel);
        NumerLabel.setBounds(172, 0, 18, 20);

        PromienComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        PromienComboBox.setToolTipText("Wybierz promie\u0144.");
        PromienComboBox.setEnabled(false);
        WOkolicyPanel.add(PromienComboBox);
        PromienComboBox.setBounds(140, 20, 80, 20);

        czyWOkolicyCheckbox.setFont(new java.awt.Font("Dialog", 0, 12));
        czyWOkolicyCheckbox.setText("szukaj w promieniu");
        czyWOkolicyCheckbox.setToolTipText("Promie\u0144 odleg\u0142o\u015bci wok\u00f3\u0142 punktu wyszukiwania.");
        czyWOkolicyCheckbox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                czyWOkolicyCheckboxActionPerformed(evt);
            }
        });

        WOkolicyPanel.add(czyWOkolicyCheckbox);
        czyWOkolicyCheckbox.setBounds(0, 20, 140, 20);

        NumerTextField.setToolTipText("Podaj nr budynku na danej ulicy, jest to punkt wok\u00f3\u0142 kt\u00f3rego odb\u0119dzie si\u0119 wyszukiwanie.");
        WOkolicyPanel.add(NumerTextField);
        NumerTextField.setBounds(190, 0, 30, 20);

        wynikiNaMapceChceckbox.setText("poka\u017c wyniki na mapce");
        wynikiNaMapceChceckbox.setToolTipText("Zaznacz, je\u015bli chcesz obejrze\u0107 wyniki na mapie.");
        WOkolicyPanel.add(wynikiNaMapceChceckbox);
        wynikiNaMapceChceckbox.setBounds(0, 40, 180, 20);

        add(WOkolicyPanel);
        WOkolicyPanel.setBounds(280, 20, 220, 60);

        BranzaPanel.setLayout(null);

        BranzaLabel.setText("Bran\u017ca");
        BranzaPanel.add(BranzaLabel);
        BranzaLabel.setBounds(0, 0, 42, 15);

        BranzaTextLabel.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0)));
        BranzaPanel.add(BranzaTextLabel);
        BranzaTextLabel.setBounds(141, 0, 119, 20);

        przegladajBranzeButton.setFont(new java.awt.Font("Dialog", 0, 10));
        przegladajBranzeButton.setText("wybierz");
        przegladajBranzeButton.setToolTipText("Wybierz odpowiedni\u0105 bran\u017c\u0119.");
        przegladajBranzeButton.setBorder(new javax.swing.border.EtchedBorder());
        przegladajBranzeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                przegladajBranzeButtonActionPerformed(evt);
            }
        });

        BranzaPanel.add(przegladajBranzeButton);
        przegladajBranzeButton.setBounds(91, 0, 50, 20);

        add(BranzaPanel);
        BranzaPanel.setBounds(10, 20, 260, 20);

        jSeparator1.setOrientation(javax.swing.SwingConstants.VERTICAL);
        add(jSeparator1);
        jSeparator1.setBounds(275, 20, 2, 60);

        jSeparator2.setOrientation(javax.swing.SwingConstants.VERTICAL);
        add(jSeparator2);
        jSeparator2.setBounds(505, 20, 2, 60);

        add(jSeparator3);
        jSeparator3.setBounds(10, 85, 644, 2);

    }//GEN-END:initComponents

    private void PoprzednieButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PoprzednieButtonActionPerformed
        // Add your handling code here:
        zacznijOd -= ile;
        kryteria = this.ustawKryteria(zacznijOd);
        KonsolaUzytkownika.konsola.zapytanie(kryteria);
    }//GEN-LAST:event_PoprzednieButtonActionPerformed

    private void czyWOkolicyCheckboxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_czyWOkolicyCheckboxActionPerformed
        czyWOkolicy = !czyWOkolicy;
        PromienComboBox.setEnabled(czyWOkolicy);
    }//GEN-LAST:event_czyWOkolicyCheckboxActionPerformed

    private void KolejneButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_KolejneButtonActionPerformed
        // Add your handling code here:
        zacznijOd += ile;
        kryteria = this.ustawKryteria(zacznijOd);
        KonsolaUzytkownika.konsola.zapytanie(kryteria);
    }//GEN-LAST:event_KolejneButtonActionPerformed

    private void przegladajBranzeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_przegladajBranzeButtonActionPerformed
        // Add your handling code here:
        komponenty.BranzaWyborOkno bwo;
        try {
            if (kb == null)
                kb = KonsolaUzytkownika.komSieciowa.pobierzKatalogBranz(KonsolaUzytkownika.konsola.getCodeBase().toString());
            bwo = new komponenty.BranzaWyborOkno(kb, this);
            bwo.show();
        } catch (Wyjatek w) {
            String errmsg = "Pobieranie katalogu bran\u017c nie powiod\u0142o si\u0119.";
            JOptionPane.showMessageDialog(this, errmsg, "B\u0142\u0105d", JOptionPane.ERROR_MESSAGE);
        }      
    }//GEN-LAST:event_przegladajBranzeButtonActionPerformed

    private void WyszukajButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_WyszukajButtonActionPerformed
        // Add your handling code here:
        //do kryteriow przekazujemy zacznijOd = 0
        zacznijOd = 0;
        kryteria = this.ustawKryteria(0);
        KonsolaUzytkownika.konsola.zapytanie(kryteria);         
    }//GEN-LAST:event_WyszukajButtonActionPerformed

    public void setBranza(shared.Branza branza) {
        this.branza = branza;
        if (branza != null)
            //BranzaTextField.setText(branza.getNazwa() + " - " + branza.getOpis());
            BranzaTextLabel.setText(branza.getNazwa());
         
    }    
    
    private int dajNrPromienia(int pr) {
        for (int i=0; i<promienieInt.length; i++) 
            if (promienieInt[i] == pr)
                return i;

        return 0;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel BranzaLabel;
    private javax.swing.JPanel BranzaPanel;
    private javax.swing.JLabel BranzaTextLabel;
    private javax.swing.JPanel DataPanel;
    private javax.swing.ButtonGroup DataZalozeniaGroup;
    private javax.swing.JLabel DataZalozeniaLabel;
    private javax.swing.JTextField DataZalozeniaTextField;
    private javax.swing.JComboBox DatyComboBox;
    private javax.swing.JPanel GuzikiPanel;
    private javax.swing.JButton KolejneButton;
    private javax.swing.ButtonGroup MapkaGroup;
    private javax.swing.JLabel NazwaLabel;
    private javax.swing.JTextField NazwaTextField;
    private javax.swing.JLabel NipLabel;
    private javax.swing.JTextField NipTextField;
    private javax.swing.JLabel NumerLabel;
    private javax.swing.JTextField NumerTextField;
    private javax.swing.JButton PoprzednieButton;
    private javax.swing.JComboBox PromienComboBox;
    private javax.swing.JLabel SlowoKluczoweLabel;
    private javax.swing.JTextField SlowoKluczoweTextField;
    private javax.swing.JPanel StringPanel;
    private javax.swing.JLabel UlicaLabel;
    private javax.swing.JTextField UlicaTextField;
    private javax.swing.ButtonGroup WOkolicyGroup;
    private javax.swing.JPanel WOkolicyPanel;
    private javax.swing.JButton WyszukajButton;
    private javax.swing.JCheckBox czyWOkolicyCheckbox;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JSeparator jSeparator4;
    private javax.swing.JButton przegladajBranzeButton;
    private javax.swing.JCheckBox wynikiNaMapceChceckbox;
    // End of variables declaration//GEN-END:variables
    
}
