/*
 * Historia.java
 *
 * Created on 25 marzec 2004, 23:03
 */

package user.opcjeUzytkownika;

import java.util.List;
import java.util.ArrayList;
import java.lang.reflect.Array;
import net.sf.hibernate.*;

import serwer.Jadro;
import shared.*;
import user.KonsolaUzytkownika;

/** Obiekty klasy Historia przechowuj zadane parametry wyszukiwania.
 *
 * @author  ula
 */
public class Historia {
    //kolejne kryteria pamietamy na liscie cyklicznej
    private Object historia;
    //pozycja na liscie gdzie mamy zapisac nowo przychodzace kryteria
    private int pozycja;
    private int size = 3;
    
    private void nastPozycja() {
        if (pozycja == size-1)
            pozycja = 0;
        else pozycja++;
    }
    
    private int poprzPozycja() {
        if (pozycja == 0)
            return size-1;
        else
            return pozycja-1;
    }
    
    /** Tworzy nowy obiekt klasy Historia. */
    public Historia() {
        try {
            historia = Array.newInstance(Class.forName("shared.Kryteria"), size);
            pozycja = 0;
        } catch (ClassNotFoundException e) {
            //throw new Wyjatek();
        }     
    }
    
    /** Zapamituje parametry wyszukiwania.
     * @param kryteria      zadane kryteria wyszukiwania
     */
    public void dodaj(Kryteria kryteria) {
        Array.set(historia,pozycja,kryteria); 
        nastPozycja();
        ArrayList stringi = stringi();
        KonsolaUzytkownika.konsola.wyswietlNaMenuHistorii((String)stringi.get(2), (String)stringi.get(1), (String)stringi.get(0));
    }
    
    /** Zwraca wszystkie zapamitane kryteria wyszukiwania w kolejnoci od
     * najstarszego.
     * @return      zapamitane parametry
     */
    public List pokaz() {
        List ret = new ArrayList();
        for (int i=0; i<size; i++) {
            ret.add(Array.get(historia, pozycja));
            nastPozycja();
        };
        return ret;
    }
    
    /** Zwraca konkretne zapamitane kryteria wyszukiwania, liczc od najstarszych.
     * @param   numer   numer pozycji w tablicy, ktrego kryteria maj by zwrcone
     * @return          zapamitane parametry
     */
    public Kryteria pokaz(int numer) {
        return (Kryteria) Array.get(historia, (pozycja + numer) % 3);
    }
    
    /** Zwraca kryteria ostatniego wyszukiwania. 
     *
     * @return  zapamitane parametry
     */
    public Kryteria ostatnie() {
        return (Kryteria) Array.get(historia, poprzPozycja());
    }
    
    /** Zwraca list stringw do wywietlenia na menu Historii. */
    private ArrayList stringi() {
        ArrayList ret = new ArrayList();
        
        for (int i=0; i<size; i++) {
            ret.add(wybierzString((Kryteria)Array.get(historia, pozycja)));
            nastPozycja();
        };
        return ret;
    }
    
    /** Wybiera string najlepiej okrelajcy parametry danego wyszukiwania 
     * np. nazw brany.
     */
    private String wybierzString(Kryteria k) {
        if (k == null)
            return " ";
        
        //ustalamy co wyswietlic w zaleznosci od tego co jest nie-nullem
        if (k.getBranza() != null)
            return k.getBranza().getNazwa();
        if (k.getSlowoKluczowe() != null)
            return k.getSlowoKluczowe();
        if (k.getNazwa() != null)
            return k.getNazwa();
        if (k.getNip() != null)
            return k.getNip();
        if (k.getUlica() != null)
            return k.getUlica();
        if (k.getRokZalozenia() != null)
            return k.getRokZalozenia().toString();
        
        //nie wiadomo co
        return "wszystkie";
    }
}
