/*
 * Ulubione.java
 *
 * Created on 25 marzec 2004, 23:22
 */

package user.opcjeUzytkownika;

import netscape.javascript.*;

import java.util.*;
import java.lang.String;
import net.sf.hibernate.*;

import serwer.Jadro;
import shared.*;
import user.*;


/** Klasa Ulubione przechowuje zapamitane w systemie przez uytkownika jego
 * ulubione ogoszenia. Ogoszenia s przyporzdkowane do wybranych przez 
 * uytkownika kategorii.
 *
 * @author  ula
 */

public class Ulubione {
    ArrayList ulubione;
        
    /** Tworzy nowy obiekt klasy Ulubione inicjujc list ulubionych ogosze
     * na podstawie danych zapamitanych w ciasteczku.
     */
    public Ulubione() {
        boolean czyCiacha = true;
            //jest kilka mozliwosci
            //1. pierwsze ciacho naszej aplikacji]
            //2. lista ulubionych w ciachu jest pusta
            //3. blad ciach
            czyCiacha = checkCookie();
        
        if (czyCiacha)
            ulubione = (ArrayList) cookieToList();        
    }
    
    
    /** Pobiera ciasteczko aplikacji niikt. 
      * @return zawarto ciasteczka lub null, gdy nie brak dostpu do ciasteczek
     */
    public String getCookie() {        
      try { 
        JSObject myBrowser = (JSObject) JSObject.getWindow(KonsolaUzytkownika.konsola);
        JSObject myDocument =  (JSObject) myBrowser.getMember("document");        
        String myCookie = (String)myDocument.getMember("cookie");
        if (myCookie.length() > 0) 
            return myCookie;
      }
      catch (Exception e){
          e.printStackTrace();
      }
      return null;
   }
    
    /** Sprawdza czy uytkownik ma wczon opcj ciasteczek w przegldarce. 
     * @return  tak jeli uytkownik ma wczon opcj ciasteczek w przegldarce
     */
    public boolean checkCookie() {
        String cc = getCookie();
        if (cc != null)
            return true;
        
       Calendar c = Calendar.getInstance();
       c.add(Calendar.YEAR, +1);
       String expires = "; expires=" + c.getTime().toString(); 

       JSObject myBrowser = JSObject.getWindow(KonsolaUzytkownika.konsola);
       JSObject myDocument =  (JSObject) myBrowser.getMember("document");
       String ret = "TEST";
       
       ret = ret.concat(expires);
       myDocument.setMember("cookie", ret);
       
       //zapisalismy testowe ciacho; spr czy da sie je odczytac
       String tt = getCookie();
       //usuwamy pozostalosci po tescie
       deleteCookie();
       if (tt == null)
           //ciacha nie sa obslugiwane
           return false;
       else
           return true;
    }    
    
    /** Usuwa ciasteczko aplikacji Niikt. */
    public void deleteCookie() {
       Calendar c = Calendar.getInstance();
       c.add(Calendar.YEAR, -5);
       String expires = "; expires=" + c.getTime().toString(); 

       JSObject myBrowser = JSObject.getWindow(KonsolaUzytkownika.konsola);
       JSObject myDocument =  (JSObject) myBrowser.getMember("document");
       String ret = "";
       
       ret = ret.concat(expires);
       myDocument.setMember("cookie", ret); 
    }    
    
    /** Tworzy kolekcj ulubionych ogosze na podstawie danych przechowywanych
     * w ciasteczku. Ciasteczko jest jedno, ogoszenia rozdzielone s znakiem $, za 
     * konkretne dane w ogoszeniu znakiem #.
     *
     * @return lista ulubionych ogosze zapamitana w ciasteczku
     */
    public List cookieToList() {
        //czy ciacho ma format w porzadku
        boolean ok = true;
        
        //pobiera ciacho z pamieci
        String cc = getCookie();
        if (cc == null)
            return new ArrayList();
        
        //dzieli je na informacje o poszczegolnych ogloszeniach
        String[] spl = cc.split("\\$");
        ArrayList ret = new ArrayList();
        for (int i=0; ok && i < spl.length; i++) {
            //info o kazdym ogloszeniu rozdzielone #            
            String[] dane = spl[i].split("\\#");                
            //na podst odczytanych danych tworzy obiekt UlubOgloszenie
            try {//ktos mogl zasyfic ciacho, wtedy kasujemy wszystko
                UlubioneOgloszenie ul = new UlubioneOgloszenie();
                System.out.println("PODSTAWIENIE danych");
                ul.podstawDane(dane);
                System.out.println("PODSTAWIENIE danych, dodanie do ulubionych");
                ret.add(ul);
            } catch (Exception e) {
                ok = false;
            }                
        };
        
        if (!ok) {
            KonsolaUzytkownika.konsola.wyswietlWyjatek("Bd w danych przechowywanych w ciasteczku. Tracimy to co byo zapamitane.");
            deleteCookie();
            return new ArrayList();
        }
        
        return ret;        
    }
    
    
    /** Tworzy ciasteczko z ulubionymi ogoszeniami na podstawie przechowywanej
     * w pamici listy ulubionych. */
    public void listToCookie() {
       Calendar c = Calendar.getInstance();
       c.add(Calendar.YEAR, 1);
       String expires = "; expires=" + c.getTime().toString();  
       
       JSObject myBrowser = JSObject.getWindow(KonsolaUzytkownika.konsola);              
       JSObject myDocument =  (JSObject) myBrowser.getMember("document");
       
       String ret = "";          
       for (int i=0; i < ulubione.size(); i++) {
           UlubioneOgloszenie ul = (UlubioneOgloszenie) ulubione.get(i);
           ret = ret.concat(ul.toString());
           ret = ret.concat("$");
       };
       
       ret = ret.concat(expires);
       myDocument.setMember("cookie", ret);
    }
    
        
    /** Dodaje nowe ogoszenie do kolekcji ulubionych ogosze.
     * @param ogloszenie    nowe ogoszenie
     */
    public void dodaj(UlubioneOgloszenie ogloszenie) {
        wstawPosortowane(ogloszenie);
        listToCookie();
        
    }
    
    /** Uaktualnia ulubione ogoszenie. 
     * @param ogl   ogoszenie z aktualnymi danymi
     * @param tel   aktualny telefon 
     */
    public void update(Ogloszenie ogl, String tel) {
        UlubioneOgloszenie ul = daj(ogl.getId());
        ul.setNazwa(ogl.getNazwa());
        ul.setUlica(ogl.getUlica().getNazwa());
        ul.setNrDomu(new Integer(ogl.getNrDomu()).toString());
        ul.setNrMieszkania(new Integer(ogl.getNrMieszkania()).toString());
        ul.setTelefon(tel);
        
        listToCookie();
    }
    
    /** Zwraca ulubione ogoszenie o podanym indentyfikatorze. 
     *
     *@param id identyfikator poszukiwanego ogoszenia
     *@return ogoszenie o podanym identyfikatorze
     */
    public UlubioneOgloszenie daj(Integer id) {
        for (int i=0; i<ulubione.size(); i++)
            if (((UlubioneOgloszenie)ulubione.get(i)).getId().equals(id))
                return (UlubioneOgloszenie)ulubione.get(i);
        //nie powinno
        return null;
    }
    
    /** Zwraca zapamitane ulubione ogoszenia.
     * @return      lista ulubionych ogosze
     */
    public List pokaz() {
        return ulubione;
    }
    
    /** Zmienia w ulubionych ogoszeniach stare ogoszenie na nowe.
     * @param stare     stare ogoszenie
     * @param nowe      nowe ogoszenie
     */
    public void zmien(UlubioneOgloszenie stare, UlubioneOgloszenie nowe) {
        ulubione.remove(stare);
        ulubione.add(nowe);
        listToCookie();
    }
    
    /** Usuwa dane ogoszenie z ulubionych ogosze.
     * @param ogloszenie    ogoszenie, ktre chcemy usun
     */
    public void usun(UlubioneOgloszenie ogloszenie) {
        ulubione.remove(ogloszenie);        
        listToCookie();
    }
    
    /** Usuwa ogoszenie o podanym numerze z listy ulubionych ogosze. 
     *
     *@param nr     numer ogoszenia na licie ulubionych
     */
    public void usun(int nr) {
        ulubione.remove(nr);
        listToCookie();
    }
    
    /** Sprawdza czy ogoszenie o podanym identyfikatorze jest ju na licie ulubionych
     * ogosze.
     * @param id    identyfikator ogoszenia
     * @return      tak lub nie
     */
    public boolean  czyUlubione(Integer id) {
        for (int i=0; i<ulubione.size(); i++)
            if (((UlubioneOgloszenie)ulubione.get(i)).getId().equals(id))
                return true;
        return false;
    }
    
    /** Generuje zestaw uywanych przez uytkownika kategorii ulubionych.
     * ogosze
     * @return      lista kategorii
     */
    public List pobierzKategorie() {
        ArrayList kat = new ArrayList();
        
        for (int i=0; i < ulubione.size(); i++) {
            String k = ((UlubioneOgloszenie) ulubione.get(i)).getKategoria();
            if (!kat.contains(k) && k != null && k.length() != 0)
                kat.add(k);
        };
        
        return kat;
    }
    
    /** Wstawia dane ogoszenie do listy ulubionych ogosze. Lista jest posortowana
     * leksykograficznie wedug kategorii ulubionych ogosze.
     *
     *@param ulub   ogoszenie do wstawienia
     */
    private void wstawPosortowane(UlubioneOgloszenie ulub) {
        for (int i = 0; i< ulubione.size(); i++)
            if (ulub.getKategoria().compareTo(((UlubioneOgloszenie)ulubione.get(i)).getKategoria()) <= 0) {
                ulubione.add(i, ulub);
                return;
            }
        ulubione.add(ulub);
    }
}
