/*
 * UlubioneOgloszenie.java
 *
 * Created on 25 marzec 2004, 23:16
 */

package user.opcjeUzytkownika;

import java.util.*;
import net.sf.hibernate.*;

import serwer.Jadro;
import shared.*;

/** Obiekty klasy UlubioneOgloszenie przechowuj dane z tych ogosze, ktre
 * uytkownik chce zapamita.
 *
 * @author  ula
 */
public class UlubioneOgloszenie {
    private Integer id; //w celach rozpoznawczych
    private String nazwa;
    private String ulica;
    private String nrDomu;
    private String nrMieszkania;
    private String tel;
    /** Wybierana przez usera. */
    private String kategoria;
    
    /** Tworzy nowy obiekt klasy UlubioneOgloszenie. */
    public UlubioneOgloszenie() {
    }
    
    /** Tworzy nowy obiekt klasy UlubioneOgloszenie, ustawiajc przy tym wartoci atrybutw. 
     *
     *@param ogloszenie     ogoszenie, z ktrego utworzone zostanie ulubione ogoszenie
     *@param telefon        telefon danego ogoszenia
     *@param kat            kategoria danego ogoszenia
     */
    public UlubioneOgloszenie(Ogloszenie ogloszenie, String telefon, String kat) {
        id = ogloszenie.getId();
        kategoria = kat;
        nazwa = ogloszenie.getNazwa();
        ulica = ogloszenie.getUlica().getNazwa();
        nrDomu = new Integer(ogloszenie.getNrDomu()).toString();
        nrMieszkania = new Integer(ogloszenie.getNrMieszkania()).toString();
        tel = telefon;
    }
    
    
    /** Uaktualnia wartoci atrybutw podanymi danymi. 
     *@param dane   tablica z nowymi danymi
     */
    public void podstawDane(String[] dane) {
        
        id = new Integer(dane[0]);
        nazwa = dane[1];
        ulica = dane[2];
        nrDomu = dane[3];
        nrMieszkania = dane[4];
        tel = dane[5];
        kategoria = dane[6];
    }
    
    /** Ustawia odpowiedni parametr ogoszenia.
     *
     *@param nazwa  ustawia nazw
     */
    public void setNazwa(String nazwa) {
        this.nazwa = nazwa;
    }
    
    /** Ustawia odpowiedni parametr ogoszenia.
     *
     *@param ulica  ustawia ulic
     */
    public void setUlica(String ulica) {
        this.ulica = ulica;
    }
    /** Ustawia odpowiedni parametr ogoszenia.
     *
     *@param nr  ustawia numer domu
     */
    public void setNrDomu(String nr) {
        nrDomu = nr;
    }
    /** Ustawia odpowiedni parametr ogoszenia.
     *
     *@param nr  ustawia numer mieszkania
     */
    public void setNrMieszkania(String nr) {
        nrMieszkania = nr;
    }
    /** Ustawia odpowiedni parametr ogoszenia.
     *
     *@param telefon  ustawia telefon
     */
    public void setTelefon(String telefon) {
        this.tel = telefon;
    }
    
    /** Ustawia odpowiedni parametr ogoszenia.
     *
     * @param kategoria  ustawia kategori
     * @see #getKategoria
     */
    public void setKategoria(String kategoria) {
        this.kategoria = kategoria;
    }
    
    /** Pobiera kategori ogoszenia.
     *
     * @return   kategoria
     * @see #setKategoria
     */
    public String getKategoria() {
        return this.kategoria;
    }
    
    /** Pobiera identyfikator ogoszenia.
     *
     *@return   identyfikator
     */
    public Integer getId() {
        return this.id;
    }
    
    /** Tworzy string z danych ogoszenia aby mona je byo przechowywa w
     * ciasteczku. 
     *
     *@return   odpowiednio sformatowany string
     */
    public String toString() {
        String ret;
        ret = id.toString()+"#"+ nazwa +"#"+ ulica +"#"+ nrDomu +"#"+ nrMieszkania +"#"+ tel +"#"+ kategoria +"#";
        return ret;
    }
    
    /** Wypisuje ulubione ogoszenie w czytelnej dla uytkownika formie. 
     *
     *@return   odpowiednio sformatowany string
     */
    public StringBuffer wypisz() {
        StringBuffer sb = new StringBuffer();
        
        sb.append(" \n");
        if (kategoria != null)
            sb.append(" " + kategoria + ":      ");
        sb.append(nazwa + " \n");
        sb.append("     " + ulica + " " + nrDomu + " m." + nrMieszkania + " \n");
        sb.append("     Tel: " + tel);
        sb.append(" \n");
                
        return sb;
    }
}
